/*
 * Xcis - X11/Lesstif client for Cluster Information Service
 * Copyright (C) 2000 Institute of Informatics, Slovak Academy of Sciences.
 * Written by Jan Astalos (astalos.ui@savba.sk)
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as published
 * by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston MA 02111-1307, USA.
 *
 * As a special exception you are allowed to link xcis executable with
 * Microline Widget Library and Plot Widgets library.
 */

#include "xcis.h"
#include "replay.h"
#include "cb.h"

char title[] ="Xcis";
char *folder_title[NFOLDERS] = {"Hosts", "Processes", "Links", "Net devices", "CPU", "Net usage"};

static String resources[] =
{
	"*fontList: -*-aplos-medium-r-*--14-*-*-*-*-*-*",
	"*XmText*.fontList: -*-aplos-medium-r-*--10-*-*-*-*-*-*",
	"*XmDrawnButton.fontList: -*-aplos-medium-r-*--10-*-*-*-*-*-*",
	"*XmPushButton.fontList: -*-aplos-medium-r-*--10-*-*-*-*-*-*",
	"*XmLProgress.fontList: -*-aplos-bold-r-*--10-*-*-*-*-*-*",
	"*XY*fontList: -*-aplos-medium-r-*--10-*-*-*-*-*-*",
//	"*XY.background: cyan4",
	"*XY.background: white",
	"*XY.foreground: black",
	"*background: #D0D0D0",
	"*foreground: black",
	"*highlightThickness: 0",
	"*topShadowColor: white",
	"*bottomShadowColor: #404040",
	"*XmLGrid.topShadowColor: #F0F0F0",
	"*XmLGrid.selectBackground: #000060",
	"*XmLGrid.selectForeground: white",
	"*XmLProgress.topShadowColor: #E0E0E0",
	"*XmLProgress.bottomShadowColor: #404040",
	"*XmToggleButton.selectColor: blue",
	"*XmToggleButton.marginHeight: 0",
	"*XmToggleButton.spacing: 4",
	"*XmText.marginHeight: 2",
	"*XmForm.marginHeight: 8",
	"*XmForm.marginWidth: 10",
	"*XmForm.horizontalSpacing: 8",
	"*XmForm.verticalSpacing: 10",
	"*XmLFolder.marginHeight: 2",
	"*XmLFolder.marginWidth: 8",
	"*XmLFolder.XmForm.marginHeight: 10",
	"*XmLFolder.XmForm.marginWidth: 10",
	"*WidgetEdit*name.foreground: #000060",
	"*WidgetEdit*class.foreground: #000060",
	"*WidgetEdit*XmText.background: white",
	"*XmLTree.cellBackground: white",
	"*XmLTree.levelSpacing: 6",
	"*XmLTree.selectBackground: #000060",
	"*XmLTree.selectForeground: white",
	"*XmLTree.connectingLineColor: black",
	
	NULL
};

#define dot_width 8
#define dot_height 11
static unsigned char dot_bits[] = {
	0x18, 0x3c, 0x3c, 0x3c,
	0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

#define check_width 14
#define check_height 10
static unsigned char check_bits[] = {
        0xfe, 0x07, 0x02, 0x1c, 0x02, 0x0f, 0x82, 0x07,
        0xc6, 0x05, 0xee, 0x04, 0x7e, 0x04, 0x7a, 0x04,
        0x32, 0x04, 0xfe, 0x07
        };

static unsigned char uncheck_bits[] = {
        0xfe, 0x07, 0x02, 0x04, 0x02, 0x04, 0x02, 0x04,
        0x02, 0x04, 0x02, 0x04, 0x02, 0x04, 0x02, 0x04,
        0x02, 0x04, 0xfe, 0x07
        };

void warning_handler(String msg)
{
}

void create_window(int argc, char *argv[])
{
	struct host_info *h;
	
	Widget top_form;
        Widget form[NFOLDERS];

        Arg args[50];
        int i,n;
        XmString s;

	Pixmap map, mask;
	
        Drawable root_window;
        Pixel fg, bg;
        unsigned int depth;
        Status stat;
	XColor col;
	XColor screen_def_return, exact_def_return;

	/*
         * Create new window for Xcis and initialize all widgets.
         */
        n = 0;
	XtSetArg(args[n], XtNiconic, 0); n++;
        XtSetArg(args[n], XmNtitle, title); n++;
	Xcis = XtAppInitialize(&app_context, "Xcis", NULL, 0, &argc, argv, resources, args, n);
#ifndef DEBUG
        XtAppSetWarningHandler(app_context, warning_handler);
#endif
        display     = XtDisplay (Xcis);
        screen      = XtScreen(Xcis);
        root_window = DefaultRootWindow(display);
        depth       = DefaultDepthOfScreen(screen);

        /*
         * Create top form.
         */
        top_form = XmCreateForm(Xcis, "top_form", NULL, 0);
        
        /*
         * Create status line and buttons.
         */
	n = 0;
	XtSetArg(args[n], XmNmarginHeight, 0); n++;
        XtSetArg(args[n], XmNmarginWidth, 0); n++;
        XtSetArg(args[n], XmNshadowThickness, 0); n++;
        XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
//        XtSetArg(args[n], XmNbottomOffset, 0); n++;
        XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
        Time_field = XmCreateLabel (top_form, "time_field", args, n);
        XtManageChild(Time_field);

        gettimeofday (&current_time, NULL);
	update_time ();
        old_time = current_time;
        
        /*
         * Create folder.
         */
        n = 0;
        XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM); n++;
        XtSetArg(args[n], XmNbottomAttachment, XmATTACH_WIDGET); n++;
//        XtSetArg(args[n], XmNbottomWidget, Buttons[PRINT]); n++;
        XtSetArg(args[n], XmNbottomWidget, Time_field); n++;
        XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
        XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
        
        Folder = XmLCreateFolder(top_form, "folder", args, n);

        for (i = 0; i < NFOLDERS; i++)
        {
                s = XmStringCreateSimple(folder_title[i]);
                form[i] = XmLFolderAddTabForm(Folder, s);
                XmStringFree(s);
        }

	XtAddCallback(Folder, XmNactivateCallback, folder_activate_cb, NULL);

        /*
         * Create tree widgets.
         */
        map = XmUNSPECIFIED_PIXMAP;
	mask = XmUNSPECIFIED_PIXMAP;

        n = 0;
        XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM); n++;
        XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
        XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
        XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;

        Hostlist = XmLCreateGrid(form[HOSTLIST], "hostlist", args, n);
        Proclist = XmLCreateTree(form[PROCLIST], "proclist", args, n);
        Linklist = XmLCreateTree(form[LINKLIST], "linklist", args, n);
        Devlist  = XmLCreateTree(form[DEVLIST],  "devlist",  args, n);

        n = 0;
        XtSetArg(args[n], XmNhighlightRowMode, True); n++;
        XtSetArg(args[n], XmNheadingRows, 2); n++;
        XtSetArg(args[n], XmNcolumns, HOST_NCOLS); n++;
        XtSetArg(args[n], XmNallowColumnResize, True); n++;
        XtSetArg(args[n], XmNcellDefaults, True); n++;
        XtSetArg(args[n], XmNsimpleWidths, "2c 15c 6c 6c 8c 8c 8c 8c 5c 5c 7c 7c 7c 12c 12c 10c"); n++;
        XtSetArg(args[n], XmNselectionPolicy, XmSELECT_NONE); n++;
        XtSetArg(args[n], XmNcellLeftBorderType, XmBORDER_NONE); n++;
        XtSetArg(args[n], XmNcellRightBorderType, XmBORDER_NONE); n++;
        XtSetArg(args[n], XmNcellTopBorderType, XmBORDER_NONE); n++;
        XtSetArg(args[n], XmNcellBottomBorderType, XmBORDER_NONE); n++;
        XtSetArg(args[n], XmNcellAlignment, XmALIGNMENT_RIGHT); n++;

        XtSetValues (Hostlist, args, n);

        XtVaSetValues (Hostlist,
                       XmNrowType, XmHEADING,
                       XmNrow, 0,
                       XmNcolumn, 0,
                       XmNcellColumnSpan, 1,
                       NULL);

        XtVaSetValues (Hostlist,
                       XmNrowType, XmHEADING,
                       XmNrow, 0,
                       XmNcolumn, 2,
                       XmNcellColumnSpan, 1,
                       NULL);

        XtVaSetValues (Hostlist,
                       XmNrowType, XmHEADING,
                       XmNrow, 0,
                       XmNcolumn, 4,
                       XmNcellColumnSpan, 1,
                       NULL);

	XtVaSetValues (Hostlist,
                       XmNrowType, XmHEADING,
                       XmNrow, 0,
                       XmNcolumn, 6,
                       XmNcellColumnSpan, 1,
                       NULL);

        XtVaSetValues (Hostlist,
                       XmNrowType, XmHEADING,
                       XmNrow, 0,
                       XmNcolumn, 0,
                       XmNcellRowSpan, 1,
                       NULL);

        XtVaSetValues (Hostlist,
                       XmNcellDefaults, True,
                       XmNcolumn, 1,
                       XmNcellAlignment, XmALIGNMENT_LEFT, NULL);

        XtVaSetValues (Hostlist,
                       XmNrowType, XmHEADING,
                       XmNrow, 0,
                       XmNcolumn, 8,
                       XmNcellRowSpan, 1,
                       NULL);

	XtVaSetValues (Hostlist,
                       XmNrowType, XmHEADING,
                       XmNrow, 0,
                       XmNcolumn, 9,
                       XmNcellRowSpan, 1,
                       NULL);

        XtVaSetValues (Hostlist,
                       XmNrowType, XmHEADING,
                       XmNrow, 0,
                       XmNcolumn, 10,
                       XmNcellColumnSpan, 2,
                       NULL);

	XtVaSetValues (Hostlist,
                       XmNrowType, XmHEADING,
                       XmNrow, 0,
                       XmNcolumn, 13,
                       XmNcellRowSpan, 1,
                       NULL);

	XtVaSetValues (Hostlist,
                       XmNrowType, XmHEADING,
                       XmNrow, 0,
                       XmNcolumn, 14,
                       XmNcellRowSpan, 1,
                       NULL);

	XtVaSetValues (Hostlist,
                       XmNrowType, XmHEADING,
                       XmNrow, 0,
                       XmNcolumn, 15,
                       XmNcellRowSpan, 1,
                       NULL);

        XtVaSetValues (Hostlist,
                       XmNcellDefaults, True,
                       XmNcolumn, 0,
                       XmNcellType, XmPIXMAP_CELL,
                       XmNcellAlignment, XmALIGNMENT_CENTER,
                       NULL);


	XtVaSetValues (Hostlist,
                       XmNcellDefaults, True,
                       XmNcolumn, HOST_COL_RELIABILITY,
		       XmNcellAlignment, XmALIGNMENT_CENTER,
                       NULL);

	XtVaSetValues (Hostlist,
                       XmNcellDefaults, True,
                       XmNcolumn, HOST_COL_SWAPRATE,
		       XmNcellAlignment, XmALIGNMENT_CENTER,
                       NULL);

	XtVaSetValues (Hostlist,
                       XmNcellDefaults, True,
                       XmNcolumn, HOST_COL_DISKRATE,
		       XmNcellAlignment, XmALIGNMENT_CENTER,
                       NULL);

        
        XmLGridSetStrings (Hostlist,
                           "Name||Performance||RAM size in KB||Swap size in KB||Proc|Ctx|Average load|||Swap in/out|Disk r/w [KB]|Reliability\n|"
                           "|max.|avail.|total|free|total|free|||1min|5min|15min|||");

	XtAddCallback(Hostlist, XmNselectCallback, host_grid_select_cb, NULL);

        XtManageChild(Hostlist);
        XtManageChild(form[HOSTLIST]);

        n = 0;
        XtSetArg(args[n], XmNhighlightRowMode, True); n++;
        XtSetArg(args[n], XmNheadingRows, 1); n++;
        XtSetArg(args[n], XmNcolumns, PROC_NCOLS); n++;
        XtSetArg(args[n], XmNallowColumnResize, True); n++;
        XtSetArg(args[n], XmNcellDefaults, True); n++;
        XtSetArg(args[n], XmNsimpleHeadings, "Command|PID|User|Pri|RSS|VM|%CPU|Majflt|Read|Write|Time|Usage"); n++;
        XtSetArg(args[n], XmNsimpleWidths, "15c 7c 7c 4c 7c 7c 7c 7c 7c 7c 7c 7c"); n++;
        XtSetArg(args[n], XmNcellLeftBorderType, XmBORDER_NONE); n++;
        XtSetArg(args[n], XmNcellRightBorderType, XmBORDER_NONE); n++;
        XtSetArg(args[n], XmNcellTopBorderType, XmBORDER_NONE); n++;
        XtSetArg(args[n], XmNcellBottomBorderType, XmBORDER_NONE); n++;
        XtSetArg(args[n], XmNcellAlignment, XmALIGNMENT_RIGHT); n++;
        
        XtSetValues (Proclist, args, n);

        XtVaSetValues (Proclist,
                       XmNcellDefaults, True,
                       XmNcolumn, PROC_COL_USER,
                       XmNcellAlignment, XmALIGNMENT_LEFT, NULL);
        XtVaSetValues (Proclist,
                       XmNcellDefaults, True,
                       XmNcolumn, PROC_COL_UPTIME,
                       XmNcellAlignment, XmALIGNMENT_CENTER, NULL);
        XtVaSetValues (Proclist,
                       XmNcellDefaults, True,
                       XmNcolumn, PROC_COL_USEDTIME,
                       XmNcellAlignment, XmALIGNMENT_CENTER, NULL);

        n = 0;
        XtSetArg(args[n], XmNhighlightRowMode, True); n++;
        XtSetArg(args[n], XmNheadingRows, 1); n++;
        XtSetArg(args[n], XmNcolumns, LINK_NCOLS); n++;
        XtSetArg(args[n], XmNallowColumnResize, True); n++;
        XtSetArg(args[n], XmNcellDefaults, True); n++;
        XtSetArg(args[n], XmNsimpleHeadings, "PID|Party host|PID|Type|-> [Bps]|<- [Bps]"); n++;
        XtSetArg(args[n], XmNsimpleWidths, "9c 18c 7c 5c 10c 10c"); n++;
        XtSetArg(args[n], XmNcellLeftBorderType, XmBORDER_NONE); n++;
        XtSetArg(args[n], XmNcellRightBorderType, XmBORDER_NONE); n++;
        XtSetArg(args[n], XmNcellTopBorderType, XmBORDER_NONE); n++;
        XtSetArg(args[n], XmNcellBottomBorderType, XmBORDER_NONE); n++;
        XtSetArg(args[n], XmNcellAlignment, XmALIGNMENT_RIGHT); n++;

        XtSetValues (Linklist, args, n);

        XtVaSetValues (Linklist,
                       XmNcellDefaults, True,
                       XmNcolumn, LINK_COL_DSTHOST,
                       XmNcellAlignment, XmALIGNMENT_LEFT, NULL);

        XtVaSetValues (Linklist,
                       XmNcellDefaults, True,
                       XmNcolumn, LINK_COL_TYPE,
                       XmNcellAlignment, XmALIGNMENT_CENTER, NULL);

        n = 0;
        XtSetArg(args[n], XmNhighlightRowMode, True); n++;
        XtSetArg(args[n], XmNheadingRows, 1); n++;
        XtSetArg(args[n], XmNcolumns, DEV_NCOLS); n++;
        XtSetArg(args[n], XmNallowColumnResize, True); n++;
        XtSetArg(args[n], XmNcellDefaults, True); n++;
        XtSetArg(args[n], XmNsimpleHeadings, "Host|Iface|Status|Transmit|Receive|Collisions"); n++;
        XtSetArg(args[n], XmNsimpleWidths, "15c 8c 6c 9c 9c 9c"); n++;
        XtSetArg(args[n], XmNcellLeftBorderType, XmBORDER_NONE); n++;
        XtSetArg(args[n], XmNcellRightBorderType, XmBORDER_NONE); n++;
        XtSetArg(args[n], XmNcellTopBorderType, XmBORDER_NONE); n++;
        XtSetArg(args[n], XmNcellBottomBorderType, XmBORDER_NONE); n++;
        XtSetArg(args[n], XmNcellAlignment, XmALIGNMENT_RIGHT); n++;

        XtSetValues (Devlist, args, n);

        XtVaSetValues (Devlist,
                       XmNcellDefaults, True,
                       XmNcolumn, DEV_COL_IFACE,
                       XmNcellAlignment, XmALIGNMENT_CENTER, NULL);

	XtVaSetValues (Devlist,
                       XmNcellDefaults, True,
                       XmNcolumn, DEV_COL_STATUS,
                       XmNcellAlignment, XmALIGNMENT_CENTER, NULL);

	XtAddCallback(Proclist, XmNexpandCallback, proclist_expand_cb, NULL);
	XtAddCallback(Proclist, XmNcollapseCallback, proclist_collapse_cb, NULL);
        XtAddCallback(Proclist, XmNselectCallback, proclist_cell_select_cb, NULL);
        XtAddCallback(Proclist, XmNscrollCallback, scroll_cb, NULL);
	XtAddCallback(Linklist, XmNexpandCallback, linklist_expand_cb, NULL);
	XtAddCallback(Linklist, XmNcollapseCallback, linklist_collapse_cb, NULL);
	XtAddCallback(Linklist, XmNactivateCallback, linklist_cell_activate_cb, NULL);
        
        XtManageChild(Proclist);
        XtManageChild(form[PROCLIST]);

        XtManageChild(Linklist);
        XtManageChild(form[LINKLIST]);

        XtManageChild(Devlist);
        XtManageChild(form[DEVLIST]);


        /*
         * CPU plot widget
         */
        n = 0;
        s = XmStringCreateSimple(CPU_units);
        XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM); n++;
        XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
        XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
        XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
        XtSetArg(args[n], XmNdoubleBuffer, True); n++;
        XtSetArg(args[n], XmNshowLegend, True); n++;
        XtSetArg(args[n], XmNyAxisLabel, s); n++;

        CPU_plot = XtCreateWidget ("CPU_plot", xyWidgetClass, form[CPUPLOT], args, n);
        XmStringFree(s);

        XtManageChild(CPU_plot);
        XtManageChild(form[CPUPLOT]);
        XYSetVisibleRange (CPU_plot, -(time_scale-1)*interval, 0, 0, CPU_scale);

        /*
         * Net plot widget
         */
        n = 0;
        s = XmStringCreateSimple(net_units);
        XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM); n++;
        XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
        XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
        XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
        XtSetArg(args[n], XmNdoubleBuffer, True); n++;
        XtSetArg(args[n], XmNshowLegend, True); n++;
        XtSetArg(args[n], XmNyAxisLabel, s); n++;

        net_plot = XtCreateWidget ("net_plot", xyWidgetClass, form[NETPLOT], args, n);
        XmStringFree(s);

        XtManageChild(net_plot);
        XtManageChild(form[NETPLOT]);
        XYSetVisibleRange (net_plot,-(time_scale-1)*interval , 0, 0, net_scale);

        XtManageChild(Folder);

	n = 0;
	s = XmStringCreateSimple ("PRINT");
        XtSetArg(args[n], XmNlabelString, s); n++;
        XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
//        XtSetArg(args[n], XmNbottomOffset, 0); n++;
        XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
        XtSetArg(args[n], XmNmarginHeight, 1); n++;
        Buttons[PRINT]  = XmCreatePushButton  (top_form, "print_button", args, n);
        XtAddCallback(Buttons[PRINT], XmNarmCallback, print_button_cb, NULL);
        XmStringFree (s);

        n = 0;
        XtSetArg(args[n], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); n++;
        XtSetArg(args[n], XmNtopWidget, Buttons[PRINT]); n++;
	XtSetArg(args[n], XmNtopOffset, 0); n++;
        XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
//        XtSetArg(args[n], XmNbottomOffset, 0); n++;
        XtSetArg(args[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
        XtSetArg(args[n], XmNshadowType, XmSHADOW_OUT); n++;
        XtSetArg(args[n], XmNmarginHeight, 1); n++;

        s = XmStringCreateSimple ("RECORD");
        XtSetArg(args[n], XmNlabelString, s); n++;
        XtSetArg(args[n], XmNleftWidget, Buttons[PRINT]); n++;
        Buttons[REC] = XmCreateDrawnButton (top_form, "Buttons[REC]", args, n);
        XmStringFree (s);

        s = XmStringCreateSimple ("REPLAY");
        XtSetArg(args[n-1], XmNlabelString, s);
        XtSetArg(args[n-2], XmNleftWidget, Buttons[REC]);
        Buttons[REP] = XmCreateDrawnButton (top_form, "replay_button", args, n);
        XmStringFree (s);

        n -= 3;
        XtSetArg(args[n], XmNwidth, 20); n++;
        XtSetArg(args[n], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); n++;
        XtSetArg(args[n], XmNtopWidget, Buttons[PRINT]); n++;
	XtSetArg(args[n], XmNtopOffset, 0); n++;
        Buttons[BEGIN] = XmCreateDrawnButton (top_form, "begin_button", args, n);
        XtSetArg(args[n], XmNleftOffset, 0); n++;
        Buttons[REW]   = XmCreateDrawnButton (top_form, "rew_button", args, n);
        Buttons[STEP]  = XmCreateDrawnButton (top_form, "step_button", args, n);
        Buttons[FWD]   = XmCreateDrawnButton (top_form, "fwd_button", args, n);
        Buttons[END]   = XmCreateDrawnButton (top_form, "end_button", args, n);

        XtAddCallback(Buttons[REC], XmNarmCallback, record_button_cb, NULL);
        XtAddCallback(Buttons[REP], XmNarmCallback, replay_button_cb, NULL);

        XtVaSetValues(Buttons[BEGIN], XmNleftWidget, Buttons[REP], NULL);
        XmLDrawnButtonSetType(Buttons[BEGIN], XmDRAWNB_ARROWLINE, XmDRAWNB_LEFT);
        XtAddCallback(Buttons[BEGIN], XmNarmCallback, begin_button_cb, NULL);
        
        XtVaSetValues(Buttons[REW], XmNleftWidget, Buttons[BEGIN], NULL);
        XmLDrawnButtonSetType(Buttons[REW], XmDRAWNB_DOUBLEARROW, XmDRAWNB_LEFT);
        XtAddCallback(Buttons[REW], XmNarmCallback, rew_button_cb, NULL);
        XtAddCallback(Buttons[REW], XmNdisarmCallback, disarm_cb, NULL);

        XtVaSetValues(Buttons[STEP], XmNleftWidget, Buttons[REW], NULL);
        XmLDrawnButtonSetType(Buttons[STEP], XmDRAWNB_ARROW, XmDRAWNB_RIGHT);
        XtAddCallback(Buttons[STEP], XmNarmCallback, step_button_cb, NULL);
        XtAddCallback(Buttons[STEP], XmNdisarmCallback, disarm_cb, NULL);

        XtVaSetValues(Buttons[FWD], XmNleftWidget, Buttons[STEP], NULL);
        XmLDrawnButtonSetType(Buttons[FWD], XmDRAWNB_DOUBLEARROW, XmDRAWNB_RIGHT);
        XtAddCallback(Buttons[FWD], XmNarmCallback, fwd_button_cb, NULL);
        XtAddCallback(Buttons[FWD], XmNdisarmCallback, disarm_cb, NULL);

        XtVaSetValues(Buttons[END], XmNleftWidget, Buttons[FWD], NULL);
        XmLDrawnButtonSetType(Buttons[END], XmDRAWNB_ARROWLINE, XmDRAWNB_RIGHT);
        XtAddCallback(Buttons[END], XmNarmCallback, end_button_cb, NULL);

        XtManageChild(Buttons[PRINT]);
        XtManageChild(Buttons[REC]);
        XtManageChild(Buttons[REP]);

        n = 0;
        XtSetArg(args[n], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); n++;
        XtSetArg(args[n], XmNtopWidget, Buttons[PRINT]); n++;
        XtSetArg(args[n], XmNtopOffset, 0); n++;
        XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
//        XtSetArg(args[n], XmNbottomOffset, 0); n++;
        XtSetArg(args[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
        XtSetArg(args[n], XmNleftWidget, Buttons[REP]); n++;
        XtSetArg(args[n], XmNrightAttachment, XmATTACH_WIDGET); n++;
        XtSetArg(args[n], XmNrightWidget, Time_field); n++;
        XtSetArg(args[n], XmNcompleteValue, 100); n++;
        XtSetArg(args[n], XmNmeterStyle, XmMETER_BOXES); n++;
        XtSetArg(args[n], XmNnumBoxes, 20); n++;
	XtSetArg(args[n], XmNshadowThickness, 1); n++;

        Progress_bar = XmLCreateProgress (top_form, "progress_bar", args, n);

        XtVaSetValues (Progress_bar,
                       XmNvalue, 50,
                       XtVaTypedArg, XmNbackground, XmRString, "white", 6,
                       XtVaTypedArg, XmNforeground, XmRString, "#000080", 8,
                       NULL);

        XtManageChild(top_form);

        n = 0;
        s = XmStringCreateSimple("Select a file");
        XtSetArg(args[n], XmNdialogTitle, s); n++;
        XtSetArg(args[n], XmNmustMatch, True); n++;
        File_selection = XmCreateFileSelectionDialog (Xcis,"file_selection", args, n);

        XtUnmanageChild (XmFileSelectionBoxGetChild(File_selection, XmDIALOG_HELP_BUTTON));

        XtAddCallback(File_selection, XmNokCallback, file_selection_cb, NULL);
        XtAddCallback(File_selection, XmNcancelCallback, file_selection_cb, NULL);
        XmStringFree(s);

        s = XmStringCreateSimple("*.rec");
        XtVaSetValues (File_selection, XmNpattern, s, NULL);
        XmStringFree(s);

        s = XmStringCreateSimple(record.path);
        XtVaSetValues (File_selection, XmNdirectory, s, NULL);
        XmStringFree(s);

        XtRealizeWidget(Xcis);

        /*
         * Alloc color and pixmap.
         */

        stat = XAllocNamedColor (display,
                                 DefaultColormapOfScreen(screen),
                                 "darkblue",
                                 &screen_def_return, &exact_def_return);

	fg = screen_def_return.pixel;
        
        pixmaps[DOT]  = XCreatePixmapFromBitmapData(display, root_window,
						    dot_bits, dot_width, dot_height,
						    fg, bg, depth);
	pixmasks[DOT] = XCreatePixmapFromBitmapData(display, root_window,
						    dot_bits, dot_width, dot_height,
						    1L, 0L, 1);

	pixmaps[CHECK] = XCreatePixmapFromBitmapData(display, root_window,
						      check_bits, check_width, check_height,
						      fg, bg, depth);
	pixmasks[CHECK] = XCreatePixmapFromBitmapData(display, root_window,
						      check_bits, check_width, check_height,
						      1L, 0L, 1);
	pixmasks[UNCHECK] = XCreatePixmapFromBitmapData(display, root_window,
							uncheck_bits, check_width, check_height,
							1L, 0L, 1);

	col.flags = DoRed | DoGreen | DoBlue;

        srand(3);
	
	for (h = hostlist; h; h = h->next) {
		if (h->color) {
			if (XAllocNamedColor (display,
					      DefaultColormapOfScreen(screen),
					      h->color,
					      &screen_def_return, &exact_def_return))
				h->pixel = screen_def_return.pixel;
		} else {
			col.red   = (short) rand();
			col.green = (short) rand();
			col.blue  = (short) rand();

			XAllocColor(display, DefaultColormapOfScreen(screen), &col);
			h->pixel = col.pixel;
		}
	}

	atexit(cleanup);
}