/*
 * Xcis - X11/Lesstif client for Cluster Information Service
 * Copyright (C) 2000 Institute of Informatics, Slovak Academy of Sciences.
 * Written by Jan Astalos (astalos.ui@savba.sk)
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as published
 * by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston MA 02111-1307, USA.
 *
 * As a special exception you are allowed to link xcis executable with
 * Microline Widget Library and Plot Widgets library.
 */

#include <stdio.h>
#include <stdarg.h>
#include <errno.h>

#include "xcis.h"

void fatal_err (const char *fmt, ...)
{
        va_list ap;
//        int err = errno;
        
        fprintf (stderr, "%s fatal err.: ", progname);
        va_start (ap, fmt);
        vfprintf (stderr, fmt, ap);
        va_end (ap);
//        if (err)
//                fprintf (stderr, ": %s", strerror (err));
        putc ('\n', stderr);
        exit (1);
}

void warning (const char *fmt, ...)
{
	va_list ap;
//	int err = errno;
        
        fprintf (stderr, "%s warning: ", progname);
        va_start (ap, fmt);
        vfprintf (stderr, fmt, ap);
        va_end (ap);
//        if (err)
//                fprintf (stderr, ": %s", strerror (err));
        putc ('\n', stderr);
}

int lprintf (char *buff, char *fmt, ...)
{
        va_list ap;
        long num = 0;
        int len = 0;
        char *c;

        va_start(ap, fmt);
        for (c = fmt; *c; c++) {
                if (*c != '%') {
                        sprintf (buff+len, "%c", *c);
                        len++;
                        continue;
                }
                c++;
                switch(*c) {
/*                case 'L':
                        num = va_arg(ap, long long);
                        break;*/
                case 'l':
                        num = va_arg(ap, long);
                        break;
                }
                c++;
                if (num >> 30) {
                        len += sprintf (buff+len, "%ldG", num >> 30);
                        continue;
                }
                if (num >> 20) {
                        len += sprintf (buff+len, "%ldM", num >> 20);
                        continue;
                }
                if (num >> 10) {
                        len += sprintf (buff+len, "%ldK", num >> 10);
                        continue;
                }
                len += sprintf (buff+len, "%ld", num);
        }
        va_end(ap);
        return len;
}

int tprintf (char *buff, char *fmt, ...)
{
        va_list ap;
        unsigned long num = 0;
        int len = 0;
        char *c;

        va_start(ap, fmt);
        for (c = fmt; *c; c++) {
                if (*c != '%') {
                        sprintf (buff+len, "%c", *c);
                        len++;
                        continue;
                }
                c++;
                switch(*c) {
                case 'l':
                        num = va_arg(ap, long);
                        break;
                }
                c++;
                if (num < 60*60) {
                        len += sprintf (buff+len, "%02ld:%02ld", num/60, num%60);
                        continue;
                }
                num /= 60*60;
                if (num < 24) {
                        len += sprintf (buff+len, "%2ld hour%c", num, num == 1 ? ' ':'s');
                        continue;
                }
                num /= 24;
                if (num < 365) {
                        len += sprintf (buff+len, "%2ld day%c", num, num == 1 ? ' ':'s');
                        continue;
                }
                num /= 365;
                len += sprintf (buff+len, "%2ld year%c", num, num == 1 ? ' ':'s');
        }
        va_end(ap);
        return len;
}
