/*
 * Xcis - X11/Lesstif client for Cluster Information Service
 * Copyright (C) 2000 Institute of Informatics, Slovak Academy of Sciences.
 * Written by Jan Astalos (astalos.ui@savba.sk)
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as published
 * by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston MA 02111-1307, USA.
 */

#include "cis.h"
#include "cis_clnt.h"

#define progname "xcis"

struct user_info {

        char           *name;
        unsigned short  id;
        char           *fullname;
        struct user_info *next;
	
};

struct cis_info {
        char *name;
        CLIENT *handle;
        struct cis_hostinfo **htab;
	int nhosts;
	struct user_info *users;

	struct cis_info *next;

};

struct host_info {
        int flag;
        int links_available;
        
        char *name;
        struct in_addr addrlist[MAX_ADDR_NUM];
#define hostaddr addrlist[0]
        struct cis_info *cis;
	struct user_info *users;

        float interval;
        unsigned short uid;
        
        struct cis_hostinfo *hostinfo, *old_hostinfo;
        float maxspeed;
	char *color;
	unsigned long pixel;
	
        unsigned long send_rate;
        unsigned long recv_rate;

        int hostlist_row;
        
        int proc_number;
        int proc_offset;
        struct cis_procinfo **proclist;
        
        int link_number;
        int link_offset;
        struct link_info **linklist;

        int dev_number;
        int dev_offset;

        int nproc;
        struct cis_procinfo *proctab;
        
        int nsock;
        struct cis_sockinfo *socktab;
        
        int nsock_old;
        struct cis_sockinfo *socktab_old;

        int ndev;
        struct cis_netdevinfo *devtab;

        void *CPU_curve;

        short hostinfo_saved_bytes;
        short proc_saved_bytes;
        short sock_saved_bytes;
        short dev_saved_bytes;

        char  hostinfo_updated;
        char  proc_updated;
        char  sock_updated;
        char  dev_updated;

        struct record_info *hostinfo_start;
        struct record_info *procinfo_start;
        struct record_info *sockinfo_start;
        struct record_info *devinfo_start;

	struct host_info *next;
};

struct link_info {

        char flag;
        char is_updated;

        short             type;
        unsigned int      src_pid;
        struct host_info *dst_host;
        unsigned int      dst_pid;
        struct in_addr    dst_addr;
        unsigned short    dst_port;
        
        unsigned long sent;
        unsigned long rcvd;
};

struct rec_info {
        char               *filename;
        FILE               *file;
        char               *path;
        int                density;
        struct timeval     jump;
        struct record_info *table, *position, *last;
        int                table_length;
};

void fatal_err (const char *fmt, ...);
int lprintf (char *buff, char *fmt, ...);
int tprintf (char *buff, char *fmt, ...);
void getparams (int argc, char **argv);
void parse_configfile (void);
struct cis_info *find_cis (char *name);
struct host_info *find_host_by_name (char *name);
void create_window(int argc, char *argv[]);
void update_time (void);
void proc_tree_sort (struct host_info *host);
void clear_host_data (struct host_info *host);
void clear_data (void);
void allarm_handler (int sig);
struct host_info *find_host(struct in_addr addr);

#define DEF_CONFIG_FILENAME         "./.xcisrc"
#define DEF_INTERVAL                1.
#define DEF_CPU_SCALE               80
#define DEF_NET_SCALE               800
#define DEF_TIME_SCALE              100
#define DEF_RECORD_DENSITY          10000
#define SOCK_INTERVAL               5
#define DELAY                       100

#ifdef _WITH_X

enum {
        HOSTLIST,
        PROCLIST,
        LINKLIST,
        DEVLIST,
        CPUPLOT,
        NETPLOT,
        NFOLDERS,
};

enum {
        ONLINE,
        RECORD,
        REPLAY,
};

enum {
        PROC_SORT_PID,
        PROC_SORT_TREE,
        PROC_SORT_PCPU,
        PROC_SORT_RSS,
        PROC_SORT_VM,
};

enum {
        HOST_SORT_NONE,
        HOST_SORT_PERF_MAX,
        HOST_SORT_PERF_AVAIL,
};

enum {
        HOST_COL_NAME = 0,
        HOST_COL_CHECK,
        HOST_COL_PERF_MAX,
        HOST_COL_PERF_AVAIL,
        HOST_COL_RAM_TOTAL,
        HOST_COL_RAM_FREE,
        HOST_COL_SWAP_TOTAL,
        HOST_COL_SWAP_FREE,
        HOST_COL_NPROC,
        HOST_COL_LOADAVG1,
        HOST_COL_LOADAVG5,
        HOST_COL_LOADAVG15,
        HOST_COL_RELIABILITY,
        HOST_NCOLS,
};

enum {
        PROC_COL_CMD,
        PROC_COL_PID,
        PROC_COL_USER,
        PROC_COL_PRIO,
        PROC_COL_RSS,
        PROC_COL_VM,
        PROC_COL_PCPU,
        PROC_COL_UPTIME,
        PROC_COL_USEDTIME,
        PROC_NCOLS,
};

enum {
        LINK_COL_PID,
        LINK_COL_DSTHOST,
        LINK_COL_DSTPID,
        LINK_COL_TYPE,
        LINK_COL_SENT,
        LINK_COL_RCVD,
        LINK_NCOLS,
};

enum {
        DEV_COL_HOST,
        DEV_COL_IFACE,
        DEV_COL_STATUS,
        DEV_COL_TX,
        DEV_COL_RX,
        DEV_COL_COLL,
        DEV_NCOLS,
};

enum {
	DOT,
	CHECK,
	UNCHECK,
};

enum {
	PRINT,
	REC,
	REP,
	BEGIN,
	REW,
	STEP,
	FWD,
	END,
	NBUTTONS
};


extern Screen *screen;
extern XtAppContext app_context;
extern Display *display;
extern Widget Xcis;

extern Pixmap pixmaps[2];
extern Pixmap pixmasks[3];

extern Widget Folder;
extern Widget Time_field;
extern Widget Hostlist;
extern Widget Proclist;
extern Widget Linklist;
extern Widget Devlist;

extern Widget Buttons[NBUTTONS];
extern Widget File_selection;
extern Widget Progress_bar;
extern Widget CPU_plot;
extern Widget net_plot;

extern int nCPU_curves;
extern XYCurve *CPU_curves;

extern struct timeval current_time, old_time;
extern char *CPU_units;
extern char *net_units;

extern float time_scale;
extern float CPU_scale;
extern float net_scale;

extern struct rec_info record;

extern char myhostname[];
extern float interval;
extern struct timeval interval_tval;

extern struct host_info *hostlist;
extern int mode;

extern int proclist_sort_type;
extern int hostlist_sort_type;

extern XtSignalId sigid;
	
void proclist_cell_select_cb(Widget w, XtPointer client_data, XtPointer cbsp);
void linklist_cell_activate_cb(Widget w, XtPointer client_data, XtPointer cbsp);
void scroll_cb(Widget w, XtPointer client_data, XtPointer cbsp);
void record_button_cb(Widget w, XtPointer client_data, XtPointer cbsp);
void replay_button_cb(Widget w, XtPointer client_data, XtPointer cbsp);
void print_button_cb(Widget w, XtPointer client_data, XtPointer cbsp);
void progress_cb (int value);
void file_selection_cb(Widget w, XtPointer client_data, XtPointer cbsp);
void timer_cb (XtPointer button_cbp, XtIntervalId *id);
void disarm_cb(Widget w, XtPointer client_data, XtPointer cbsp);
void begin_button_cb(Widget w, XtPointer client_data, XtPointer cbsp);
void rew_button_cb(Widget w, XtPointer client_data, XtPointer cbsp);
void step_button_cb(Widget w, XtPointer client_data, XtPointer cbsp);
void fwd_button_cb(Widget w, XtPointer client_data, XtPointer cbsp);
void end_button_cb(Widget w, XtPointer client_data, XtPointer cbsp);
void host_grid_select_cb(Widget w, XtPointer client_data, XtPointer cbsp);

char *string_to_text(XmString s);
void rewind_record_file (struct timeval t);
void parse_next_interval (void);
int tvalcmp (struct timeval t1, struct timeval t2);
void tvaladd (struct timeval *t, struct timeval inc);
void tvalsub (struct timeval *t, struct timeval dec);
void hostlist_sort (void);
void proclist_update (struct host_info *host);
void socklist_update (struct host_info *host);
void devlist_update (struct host_info *host);
void linklist_update (void);

void parse_next_interval (void);
void rewind_record_file (struct timeval t);

void hostlist_update (struct host_info *host);
void proctab_update (struct host_info *host, struct cis_procinfo *ptab, int len);
void socktab_update (struct host_info *host, struct cis_sockinfo *stab, int len);
void devtab_update (struct host_info *host, struct cis_netdevinfo *dtab, int len);

void CPU_curve_update (struct host_info *host);
void update_curves (void);

#define tvle(a,b) (a.tv_sec < b.tv_sec || (a.tv_sec == b.tv_sec && a.tv_usec < b.tv_usec))
#define tvgt(a,b) (a.tv_sec > b.tv_sec || (a.tv_sec == b.tv_sec && a.tv_usec > b.tv_usec))

#endif


