/*
 * Xcis - X11/Lesstif client for Cluster Information Service
 * Copyright (C) 2000 Institute of Informatics, Slovak Academy of Sciences.
 * Written by Jan Astalos (astalos.ui@savba.sk)
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as published
 * by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston MA 02111-1307, USA.
 *
 * As a special exception you are allowed to link xcis executable with
 * Microline Widget Library and Plot Widgets library.
 */

#include <Xm/Xm.h>
#if XmVersion >= 1002
#include <Xm/PrimitiveP.h>
#endif
#include <Xm/Form.h>
#include <Xm/PushB.h>
#include <Xm/DrawnB.h>
#include <Xm/Label.h>
#include <Xm/Scale.h>
#include <Xm/TextF.h>
#include <Xm/FileSB.h>

#include <XmL/Folder.h>
#include <XmL/Tree.h>
#include <XmL/Progress.h>

#include <Xm/DrawnB.h>

#include <X11/Intrinsic.h>
#include "XY.h"

#define _WITH_X

#include "xcis.h"

void parse_next_interval (void)
{
        struct record_info *r;
        struct host_info *h;
        struct cis_hostinfo *hi;
        struct cis_procinfo *ptab;
        struct cis_sockinfo *stab;
        struct cis_netdevinfo *dtab;
        struct timeval end_time = old_time;
        int len;

        if (record.position == record.last)
                return;
        
        tvaladd (&end_time, interval_tval);

        if (tvalcmp (end_time, record.last->time) > 0)
                end_time = record.last->time;

        current_time = end_time;
        
        for (r = record.position;
             tvalcmp (r->time, end_time) <= 0 && r < record.last; r++) {
                if (!r->host_ptr || !(h = r->host_ptr)->flag)
                        continue;

                current_time = r->time;

                fseek (record.file, r->offset, SEEK_SET);

                if (cisReadRecord (record.file, r) < 0)
                        continue;

                switch (r->type) {
                        
		case CIS_HOSTINFO:
			((struct cis_hostinfo *) r->data)->performance = h->hostinfo->performance;
                        *h->hostinfo = *(struct cis_hostinfo *) r->data;
                        free(r->data);
                        hostlist_update (h);
                        hostlist_sort();
                        CPU_curve_update(h);
                        break;
                        
                case CIS_HOSTINFO_CHANGES:
                        cisHostinfoApplyChanges (h->hostinfo, r->data, r->length, &hi);
                        *h->hostinfo = *hi;
                        free(hi);
                        free(r->data);
                        hostlist_update (h);
                        hostlist_sort();
                        CPU_curve_update(h);
                        break;
                        
                case CIS_PROCINFO:
                        proctab_update (h, (struct cis_procinfo *)r->data, r->length / sizeof (struct cis_procinfo));
                        proclist_update (h);
                        break;
                        
                case CIS_PROC_CHANGES:
                        len = cisProcApplyChanges (h->proctab, h->nproc, r->data, r->length, &ptab);
                        free (r->data);
                        proctab_update (h, ptab, len);
                        proclist_update (h);
                        break;

                case CIS_SOCKINFO:
                        socktab_update (h, (struct cis_sockinfo *)r->data, r->length / sizeof (struct cis_sockinfo));
                        socklist_update (h);
                        linklist_update();
                        break;

                case CIS_SOCK_CHANGES:
                        len = cisSockApplyChanges (h->socktab, h->nsock, r->data, r->length, &stab);
                        free (r->data);
                        socktab_update (h, stab, len);
                        socklist_update (h);
                        linklist_update();
                        break;

                case CIS_NETDEVINFO:
                        devtab_update (h, (struct cis_netdevinfo *)r->data, r->length / sizeof (struct cis_netdevinfo));
                        devlist_update (h);
                        break;
                        
                case CIS_NETDEV_CHANGES:
                        len = cisNetdevApplyChanges (h->devtab, h->ndev, r->data, r->length, &dtab);
                        free (r->data);
                        devtab_update (h, dtab, len);
                        devlist_update (h);
                        break;
                }
        }

        record.position = r;

        update_curves ();
        update_time ();
}


void rewind_record_file (struct timeval t)
{
        struct record_info *r, *rmargin, *lmargin, *start;
        struct host_info *h;
        struct cis_hostinfo *hi;
        struct cis_procinfo *ptab;
        struct cis_sockinfo *stab;
        struct cis_netdevinfo *dtab;
        struct timeval scale, start_time;
        int len;

        clear_data ();

        /* Time corrections */
        if (tvgt (t, record.last->time))
                t = record.last->time;

        start_time = record.table->time;
        tvaladd (&start_time, interval_tval);
        if (tvle (t, start_time))
                t = start_time;

        /* Finding time constraints */
        if (tvle (record.position->time, t)) {
                for (rmargin = record.position; rmargin < record.last; rmargin++)
                        if (tvgt (rmargin->time, t))
                                break;
        } else
                for (rmargin = record.position; rmargin > record.table; rmargin--)
                        if (tvle (rmargin->time, t))
                                break;
                
        current_time = t;

        sectotval (scale, time_scale);
        tvalsub (&t, scale);

        old_time = t;
        
        for (lmargin = rmargin; lmargin > record.table; lmargin--)
                if (tvle (lmargin->time, t))
                        break;

        start = rmargin;
	for (h = hostlist; h; h = h->next) {
                if (!h->flag) continue;

                /* Find start of hostinfo. */
                for (r = lmargin; r > record.table; r--)
                        if (r->host_ptr == h && r->type == CIS_HOSTINFO)
                                break;

                h->hostinfo_start = r;
                if (start > r)
                        start = r;

                /* Find start of procinfo. */
                for (r = rmargin; r > record.table; r--)
                        if (r->host_ptr == h && r->type == CIS_PROCINFO)
                                break;

                h->procinfo_start = r;
                if (start > r)
                        start = r;

                /* Find start of sockinfo. */
                for (r = rmargin; r > record.table; r--)
                        if (r->host_ptr == h && r->type == CIS_SOCKINFO)
                                break;

                h->sockinfo_start = r;
                if (start > r)
                        start = r;

                /* Find start of netdevinfo. */
                for (r = lmargin; r > record.table; r--)
                        if (r->host_ptr == h && r->type == CIS_NETDEVINFO)
                                break;

                h->devinfo_start = r;
                if (start > r)
                        start = r;
        }
        for (r = start; r < rmargin; r++) {
                if (!r->host_ptr || !(h = r->host_ptr)->flag)
                        continue;

                switch (r->type) {
                case CIS_HOSTINFO:
                case CIS_HOSTINFO_CHANGES:
                        if (r < h->hostinfo_start)
                                continue;
                        break;
                case CIS_PROCINFO:
                case CIS_PROC_CHANGES:
                        if (r < h->procinfo_start)
                                continue;
                        break;
                case CIS_SOCKINFO:
                case CIS_SOCK_CHANGES:
                        if (r < h->sockinfo_start)
                                continue;
                        break;
                case CIS_NETDEVINFO:
                case CIS_NETDEV_CHANGES:
                        if (r < h->devinfo_start)
                                continue;
                        break;
                }

                fseek (record.file, r->offset, SEEK_SET);
                if (cisReadRecord (record.file, r) < 0)
                        return;

                current_time = r->time;
                
                switch (r->type) {
                        
                case CIS_HOSTINFO:
			((struct cis_hostinfo *) r->data)->performance = h->hostinfo->performance;
                        *h->hostinfo = *(struct cis_hostinfo *) r->data;
                        free(r->data);
                        hostlist_update (h);
                        break;

                case CIS_HOSTINFO_CHANGES:
                        cisHostinfoApplyChanges (h->hostinfo, r->data, r->length, &hi);
                        *h->hostinfo = *hi;
                        free(hi);
                        free(r->data);
                        break;
                        
                case CIS_PROCINFO:
                        proctab_update (h, (struct cis_procinfo *)r->data, r->length / sizeof (struct cis_procinfo));
                        break;
                        
                case CIS_PROC_CHANGES:
                        len = cisProcApplyChanges (h->proctab, h->nproc, r->data, r->length, &ptab);
                        free (r->data);
                        proctab_update (h, ptab, len);
                        break;

                case CIS_SOCKINFO:
                        socktab_update (h, (struct cis_sockinfo *)r->data, r->length / sizeof (struct cis_sockinfo));
                        break;

                case CIS_SOCK_CHANGES:
                        len = cisSockApplyChanges (h->socktab, h->nsock, r->data, r->length, &stab);
                        free (r->data);
                        socktab_update (h, stab, len);
                        break;

                case CIS_NETDEVINFO:
                        devtab_update (h, (struct cis_netdevinfo *)r->data, r->length / sizeof (struct cis_netdevinfo));
                        devlist_update (h);
                        break;
                        
                case CIS_NETDEV_CHANGES:
                        len = cisNetdevApplyChanges (h->devtab, h->ndev, r->data, r->length, &dtab);
                        free (r->data);
                        devtab_update (h, dtab, len);
                        devlist_update (h);
                        break;
                }

                if ((r->type == CIS_HOSTINFO || r->type == CIS_HOSTINFO_CHANGES) &&
                    r >= lmargin)
                        CPU_curve_update (h);
        }

	for (h = hostlist; h; h = h->next) {
                if (!h->flag)
                        continue;
                else {
                        hostlist_update (h);
                        proclist_update (h);
                        socklist_update (h);
                }
        }

        record.position = rmargin;

        linklist_update ();
        hostlist_sort();

        update_curves ();
        update_time ();
}

