/*
 * Xcis - X11/Lesstif client for Cluster Information Service
 * Copyright (C) 2000 Institute of Informatics, Slovak Academy of Sciences.
 * Written by Jan Astalos (astalos.ui@savba.sk)
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as published
 * by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston MA 02111-1307, USA.
 *
 * As a special exception you are allowed to link xcis executable with
 * Microline Widget Library and Plot Widgets library.
 */

#include <Xm/Xm.h>
#if XmVersion >= 1002
#include <Xm/PrimitiveP.h>
#endif
#include <Xm/Form.h>
#include <Xm/PushB.h>
#include <Xm/DrawnB.h>
#include <Xm/Label.h>
#include <Xm/Scale.h>
#include <Xm/TextF.h>
#include <Xm/FileSB.h>

#include <XmL/Folder.h>
#include <XmL/Tree.h>
#include <XmL/Progress.h>

#include <Xm/DrawnB.h>

#include <X11/Intrinsic.h>
#include "XY.h"

#define _WITH_X

#include "xcis.h"

char *printpath = "./";

void proclist_cell_select_cb(Widget w, XtPointer client_data, XtPointer cbsp)
{
        XmLGridCallbackStruct *cbs = (XmLGridCallbackStruct *) cbsp;
        int old_type = proclist_sort_type;
        struct host_info *h;
        
        if (cbs->rowType != XmHEADING)
                return;

        if (cbs->columnType != XmCONTENT)
                return;

        switch (cbs->column) {
        case PROC_COL_CMD:
                proclist_sort_type = PROC_SORT_TREE;
                break;
        case PROC_COL_PID:
                proclist_sort_type = PROC_SORT_PID;
                break;
        case PROC_COL_PCPU:
                proclist_sort_type = PROC_SORT_PCPU;
                break;
        case PROC_COL_RSS:
                proclist_sort_type = PROC_SORT_RSS;
                break;
        case PROC_COL_VM:
                proclist_sort_type = PROC_SORT_VM;
                break;
        }

        XtVaSetValues(Proclist, XmNlayoutFrozen, True, NULL);
        if (proclist_sort_type != old_type)
                for (h = hostlist; h; h = h->next)
                        proc_tree_sort (h);
        XtVaSetValues(Proclist, XmNlayoutFrozen, False, NULL);
}

void linklist_cell_activate_cb(Widget w, XtPointer client_data, XtPointer cbsp)
{
        XmLGridCallbackStruct *cbs = (XmLGridCallbackStruct *) cbsp;
        struct host_info *h;
        struct cis_procinfo *process;
        struct link_info *link;
        XmLGridRow rowp;
        unsigned int pid;
        int level, row;
        
        if (cbs->rowType != XmCONTENT)
                return;

        if (cbs->columnType != XmCONTENT)
                return;

        if (cbs->column != LINK_COL_PID && cbs->column != LINK_COL_DSTPID)
                return;

        rowp = XmLGridGetRow (Linklist, XmCONTENT, cbs->row);
        XtVaGetValues(Linklist,
                      XmNrowPtr, rowp,
                      XmNrowLevel, &level,
                      XmNrowUserData, &link,
                      NULL);

        if (!level)
                return;
        
        switch (cbs->column) {
        case LINK_COL_PID:
                for (h = hostlist; h && h->link_offset + h->link_number + 1 < cbs->row; h = h->next)
			;
                pid = link->src_pid;
                break;
                
        case LINK_COL_DSTPID:

                h = link->dst_host;
                if (!h)
                        return;
                pid = link->dst_pid;
                break;
        }

        XtVaSetValues(Proclist,
                      XmNrow, h->proc_offset,
                      XmNrowIsExpanded, True,
                      NULL);

        for (row = h->proc_offset+1; row < h->proc_offset + h->proc_number + 1; row++) {
                rowp = XmLGridGetRow (Proclist, XmCONTENT, row);
                XtVaGetValues(Proclist,
                              XmNrowPtr, rowp,
                              XmNrowUserData, &process,
                              NULL);

                if (process->pid == pid) {
                        XmLFolderSetActiveTab (Folder, PROCLIST, FALSE);
                        XmLGridSelectRow (Proclist, row, 0);
                        XmLGridSetFocus (Proclist, row, 0);
                }
        }
        XmUpdateDisplay (Xcis);
}

void scroll_cb(Widget w, XtPointer client_data, XtPointer cbsp)
{
        XtVaSetValues(Proclist, XmNlayoutFrozen, False, NULL);
}

void record_button_cb(Widget w, XtPointer client_data, XtPointer cbsp)
{
        time_t ct;
        struct tm *tmp;
        char buff[MAXHOSTNAMELEN+32], *newname;
        struct host_info *h;
        int len;
        
        if (mode == RECORD) {
                XtVaSetValues (w, XmNshadowType, XmSHADOW_OUT, NULL);
                XtVaSetValues (Buttons[REP], XmNsensitive, True, NULL);
                mode = ONLINE;
                fclose (record.file);
        } else {

                ct = time (NULL);
                tmp = localtime (&ct);

                len = strftime (buff, MAXHOSTNAMELEN+34, "%Y.%m.%d_%H:%M:%S", tmp);
                sprintf (buff+len, "_%s.rec", myhostname);
                newname = realloc (record.filename, strlen (buff)+strlen(record.path)+1);
                if (!newname)
                        return;
                record.filename = newname;

                strcpy (newname, record.path);
                strcat (newname, buff);
                
                record.file = fopen (record.filename, "w+");
                if (!record.file)
                        return;

                for (h = hostlist; h; h = h->next) {
                        h->hostinfo_saved_bytes = record.density;
                        h->proc_saved_bytes     = record.density;
                        h->sock_saved_bytes     = record.density;
                        h->dev_saved_bytes      = record.density;
                }

                cisSaveHeader (record.file);
                
                XtVaSetValues (w, XmNshadowType, XmSHADOW_IN, NULL);
                XtVaSetValues (Buttons[REP], XmNsensitive, False, NULL);
                mode = RECORD;
        }
}

void replay_button_cb(Widget w, XtPointer client_data, XtPointer cbsp)
{
	struct itimerval it;
	Widget *button;

        if (mode == REPLAY) {
                XtVaSetValues (w, XmNshadowType, XmSHADOW_OUT, NULL);
                XtVaSetValues (Buttons[RECORD], XmNsensitive, True, NULL);

		for (button = Buttons+BEGIN; button <= Buttons+END; button++)
			XtUnmanageChild(*button);

                fclose (record.file);
                free (record.table);

                clear_data();

                mode = ONLINE;

                sectotval (it.it_interval, interval);
                sectotval (it.it_value   , interval);
                setitimer (ITIMER_REAL, &it, NULL);

                allarm_handler(0);
                XtNoticeSignal (sigid);
        } else {

                XtManageChild (File_selection);
                
                XtVaSetValues (w, XmNshadowType, XmSHADOW_IN, NULL);
        }
}

char *print_extensions[] = {
        "hosts",
        "processes",
        "links",
        "netdevs",
        "CPUplot.eps",
        "Netplot.eps",
};

void print_button_cb(Widget w, XtPointer client_data, XtPointer cbsp)
{
        time_t ct;
        struct tm *tmp;
        int active_folder;
        char buff[MAXHOSTNAMELEN+34], *filename, *newname;
        int len;
        FILE *file;

        XtVaGetValues (Folder, XmNactiveTab, &active_folder, NULL);

        ct = current_time.tv_sec;
        tmp = localtime (&ct);

        len = strftime (buff, MAXHOSTNAMELEN+34, "%Y.%m.%d_%H:%M:%S", tmp);
        sprintf (buff+len, "_%s.%s", myhostname, print_extensions[active_folder]);

        filename = strdup (printpath);
        newname = realloc (filename, strlen (buff)+strlen(filename)+1);
        if (!newname)
                goto end;
        filename = newname;

        strcat (filename, buff);

        file = fopen (filename, "w+");
        if (!file)
                goto end;

        switch (active_folder) {
        case HOSTLIST:
                XmLGridWrite (Hostlist, file, XmFORMAT_PAD, 0, False);
                break;
        case PROCLIST:
                XmLGridWrite (Proclist, file, XmFORMAT_PAD, 0, False);
                break;
        case LINKLIST:
                XmLGridWrite (Linklist, file, XmFORMAT_PAD, 0, False);
                break;
        case DEVLIST:
                XmLGridWrite (Devlist, file, XmFORMAT_PAD, 0, False);
                break;
        case CPUPLOT:
                XYPrintContents (CPU_plot, filename);
                break;
        case NETPLOT:
                XYPrintContents (net_plot, filename);
                break;
        }

        fclose (file);
        
    end:
        free (filename);
}

void progress_cb (int value)
{
        XtVaSetValues (Progress_bar, XmNvalue, value, NULL);
        
        while (XtAppPending (app_context))
                XtAppProcessEvent(app_context, XtIMAll);
}

void file_selection_cb(Widget w, XtPointer client_data, XtPointer cbsp)
{
        static struct itimerval it = {{0,0}, {0,0}};
        XmFileSelectionBoxCallbackStruct *cbs = cbsp;
        char *filename;
        struct cis_header header;
	struct record_info *r;
	Widget *button;
        
        if (cbs->reason == XmCR_OK) {

                filename = string_to_text(cbs->value);

                XtUnmanageChild (w);

                record.file = fopen (filename, "r");
                if (!record.file) {
                        printf ("cannot open file %s\n", filename);
                        goto cancel;
                }

                if (cisReadHeader (record.file, &header) < 0 ||
                    header.version != CIS_RECORD_VERSION) {
                        fclose (record.file);
                        goto cancel;
                }

                XtManageChild (Progress_bar);
                record.table_length = cisParseFile (record.file, &record.table, progress_cb);
                XtUnmanageChild (Progress_bar);
                if (record.table_length <= 0) {
                        fclose (record.file);
                        goto cancel;
                }

                setitimer (ITIMER_REAL, &it, NULL);

                record.position = record.table;
                record.last     = record.table + record.table_length-1;
                
                for (r = record.table; r <= record.last; r++)
                        r->host_ptr = find_host (r->host);

                old_time = current_time = record.table->time;

                clear_data();
                parse_next_interval();

                update_time ();

		for (button = Buttons+BEGIN; button <= Buttons+END; button++)
			XtManageChild(*button);

                XtVaSetValues (Buttons[RECORD], XmNsensitive, False, NULL);

                mode = REPLAY;

                XmUpdateDisplay (Xcis);

                return;
        }

    cancel:
        
        XtVaSetValues (Buttons[REP], XmNshadowType, XmSHADOW_OUT, NULL);
        XtUnmanageChild (w);
}

XtIntervalId timer;

void timer_cb (XtPointer button_cbp, XtIntervalId *id)
{
        ((XtCallbackProc) button_cbp) (NULL,NULL,NULL);
}

void disarm_cb(Widget w, XtPointer client_data, XtPointer cbsp)
{
        XtRemoveTimeOut(timer);
}

void begin_button_cb(Widget w, XtPointer client_data, XtPointer cbsp)
{
        rewind_record_file (record.table->time);
}

void rew_button_cb(Widget w, XtPointer client_data, XtPointer cbsp)
{
        struct timeval tv = current_time;

        tvalsub (&tv, record.jump);

        rewind_record_file (tv);
        timer = XtAppAddTimeOut (app_context, DELAY, timer_cb, rew_button_cb);
}

void step_button_cb(Widget w, XtPointer client_data, XtPointer cbsp)
{
        parse_next_interval();
        timer = XtAppAddTimeOut (app_context, DELAY, timer_cb, step_button_cb);
}

void fwd_button_cb(Widget w, XtPointer client_data, XtPointer cbsp)
{
        struct timeval tv = current_time;

        tvaladd (&tv, record.jump);

        rewind_record_file (tv);
        timer = XtAppAddTimeOut (app_context, DELAY, timer_cb, fwd_button_cb);
}

void end_button_cb(Widget w, XtPointer client_data, XtPointer cbsp)
{
        rewind_record_file (record.last->time);
}

void host_grid_select_cb(Widget w, XtPointer client_data, XtPointer cbsp)
{
        XmLGridCallbackStruct *cbs = (XmLGridCallbackStruct *) cbsp;
        XmLGridRow row;
        XmLGridColumn column;
        Pixmap mask;
        struct host_info *host, *h;
        XmString s;
        XYCurve *c;
        int old_type;

        if (cbs->reason != XmCR_SELECT_CELL)
                return;
        if (cbs->rowType != XmCONTENT) {

                old_type = hostlist_sort_type;

                switch (cbs->column) {
                case HOST_COL_NAME:
                        hostlist_sort_type = HOST_SORT_NONE;
                        break;
                case HOST_COL_PERF_MAX:
                        hostlist_sort_type = HOST_SORT_PERF_MAX;
                        break;
                case HOST_COL_PERF_AVAIL:
                        hostlist_sort_type = HOST_SORT_PERF_AVAIL;
                        break;
                default:
                        return;
                }
                if (hostlist_sort_type == old_type)
                        return;
                hostlist_sort ();
                return;
        }
        
        row = XmLGridGetRow(w, cbs->rowType, cbs->row);
        column = XmLGridGetColumn(w, XmCONTENT, 0);

        XtVaGetValues(w,
                      XmNrowPtr, row,
                      XmNcolumnPtr, column,
                      XmNcellPixmapMask, &mask,
                      XmNrowUserData, &host,
                      NULL);
        
	if (mask == pixmasks[UNCHECK]) {
                mask = pixmasks[CHECK];

                s = XmStringCreateSimple(host->name);
                XmLTreeAddRow(Proclist, 0, True, False, host->proc_offset,
                              XmUNSPECIFIED_PIXMAP, XmUNSPECIFIED_PIXMAP, s);
                XmLTreeAddRow(Linklist, 0, True, False, host->link_offset,
                              XmUNSPECIFIED_PIXMAP, XmUNSPECIFIED_PIXMAP, s);
//                XmLTreeAddRow(Devlist, 0, True, True, host->dev_offset,
//                              XmUNSPECIFIED_PIXMAP, XmUNSPECIFIED_PIXMAP, s);

                XmStringFree (s);

		for (h = host->next; h; h = h->next) {
			h->proc_offset++;
                        h->link_offset++;
//			h->dev_offset++;
		}

		c = NULL;
		for (h = host->next; h; h = h->next)
			if (h->flag) {
				c = h->CPU_curve;
				break;
			}
		if (c) {
			memmove(c+1, c, (nCPU_curves - (c - CPU_curves))*sizeof (XYCurve));
			for (h = host->next; h; h = h->next)
				if (h->flag)
					((XYCurve *) h->CPU_curve)++;
		} else
			c = CPU_curves+nCPU_curves;
		
		c->name   = XmStringCreateSimple(host->name);
                c->points = NULL;
                c->nPoints = 0;
                
		host->CPU_curve = c;
		c->markerPixel = host->pixel;
		c->linePixel   = host->pixel;

		nCPU_curves++;

                host->flag = TRUE;

        } else {
                mask = pixmasks[UNCHECK];

                clear_host_data (host);
                proclist_update (host);
                socklist_update (host);
                devlist_update  (host);
                linklist_update ();

                XmLGridDeleteRows (Proclist, XmCONTENT, host->proc_offset, 1);
                XmLGridDeleteRows (Linklist, XmCONTENT, host->link_offset, 1);
//                XmLGridDeleteRows (Devlist,  XmCONTENT, host->dev_offset,  1);
		for (h = host->next; h; h = h->next) {
                        h->proc_offset--;
                        h->link_offset--;
//                        h->dev_offset--;
                }
		c = host->CPU_curve;
		XmStringFree (c->name);

		memmove(c, c+1, (nCPU_curves - (c - CPU_curves) - 1)*sizeof (XYCurve));
		
                for (h = host->next; h; h = h->next)
			if (h->flag)
				((XYCurve *) h->CPU_curve)--;

                host->CPU_curve = NULL;

                nCPU_curves--;

                host->flag = FALSE;
        }
        XtVaSetValues(w,
                      XmNrow, cbs->row,
                      XmNcolumn, 0,
                      XmNcellPixmapMask, mask,
                      NULL);

	XYSetCurves (CPU_plot, CPU_curves, nCPU_curves, XY_NO_RESCALE, True);
}
