/*
 * Cluster Information Service - a monitoring system for Linux clusters
 * Copyright (C) 2000 Institute of Informatics, Slovak Academy of Sciences.
 * Written by Jan Astalos (astalos.ui@savba.sk)
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as published
 * by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston MA 02111-1307, USA.
 *
 * LM sensors monitor. Provides CIS server with information from HW sensors.
 */

#include <sys/time.h>
#include <unistd.h>
#include <syslog.h>

#include "cis.h"
#include "mon_common.h"

int main(int argc, char *argv[])
{
	struct timeval timeout, interval_tv;
	fd_set fdset;

	monitor_type = LMMON;
	
        prepare_init(argc, argv);

	lmmon.init();

	connect_server();
	
#ifndef DEBUG
	daemonize();
#endif

        lmmon.send_init();

        lmmon.check();
	full_msg = FALSE;
	
	sectotval(interval_tv, interval);
	timeout = interval_tv;

	FD_ZERO(&fdset);
	FD_SET(socketfd, &fdset);
	
	for (;;) {
		switch (select (FD_SETSIZE, &fdset, NULL, NULL, &timeout)) {
		case 1:
		case 0:
			if (recv_msg())
				lmmon.send_init();
			lmmon.check();
			if (!full_msg)
				send_msg();
			if (!full_mode)
				full_msg = FALSE;

			timeout = interval_tv;
			break;
		case -1:
			timeout = interval_tv;
			break;
		default:
			break;
		}
		if (server_ok)
			FD_SET(socketfd, &fdset);
		else
			FD_CLR(socketfd, &fdset);
	}
}
