/*
 * Cluster Information Service - a monitoring system for Linux clusters
 * Copyright (C) 2000 Institute of Informatics, Slovak Academy of Sciences.
 * Written by Jan Astalos (astalos.ui@savba.sk)
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as published
 * by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston MA 02111-1307, USA.
 */

#ifndef HISTORY_LENGTH
#define HISTORY_LENGTH     60
#endif

struct history_value {
        unsigned long time;
        unsigned long change;
};

struct history {

        struct history_value history[HISTORY_LENGTH];
        struct history_value *last;

        unsigned long interval;
        unsigned long sum;
};

void init_history(struct history *h, unsigned long time);
void history_add(struct history *h, unsigned long time, unsigned long change);
void history_sum(struct history *h, int count, unsigned long *interval, unsigned long *sum);
