/*
 * Cluster Information Service - a monitoring system for Linux clusters
 * Copyright (C) 2000 Institute of Informatics, Slovak Academy of Sciences.
 * Written by Jan Astalos (astalos.ui@savba.sk)
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as published
 * by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston MA 02111-1307, USA.
 *
 * History manipulating functions.
 */

#include "history.h"

void init_history(struct history *h, unsigned long time)
{
        struct history_value *hp;
        
        for (hp = h->history;
             hp < h->history+HISTORY_LENGTH;
	     hp++) {
		hp->time = time;
		hp->change = 0;
	}
	h->last = h->history;
	h->sum = 0;
	h->interval = 0;
}

void history_add(struct history *h, unsigned long time, unsigned long change)
{
	struct history_value *hp;

	if (!change)
		return;
	
        h->last++;
        if (h->last == h->history + HISTORY_LENGTH)
                h->last = h->history;

        hp = h->last;
        
        h->sum     += change - hp->change;
        h->interval = time - hp->time;

        hp->time     = time;
        hp->change   = change;
}

void history_sum(struct history *h, int count, unsigned long *interval, unsigned long *sum)
{
	struct history_value *hp = h->last;
	unsigned long s = 0;

	for (; count; count--) {

		s += hp->change;

		if (hp == h->history)
			hp = h->history + HISTORY_LENGTH;

		hp--;
	}
	*interval = h->last->time - hp->time;
	*sum = s;
}
