/*
 * Cluster Information Service - a monitoring system for Linux clusters
 * Copyright (C) 2000 Institute of Informatics, Slovak Academy of Sciences.
 * Written by Jan Astalos (astalos.ui@savba.sk)
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as published
 * by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston MA 02111-1307, USA.
 *
 */

#ifndef _hash_h
#define _hash_h

struct hash_t_ {
	int  length;
	int  nitems;
	int  key_offset;
	int  key_length;
	int  hcode_offset;
	void **table;
};

typedef struct hash_t_ hash_t;

hash_t *hash_create(int length, int key_offset, int key_length, int hcode_offset);
void hash_destroy(hash_t *ht);
void hash_clear(hash_t *ht);
void *hash_find(hash_t *ht, void *keyptr);
int hash_insert(hash_t *ht, void *item);
int hash_remove(hash_t *ht, void *keyptr);

#endif