/*
 * Cluster Information Service - a monitoring system for Linux clusters
 * Copyright (C) 2000 Institute of Informatics, Slovak Academy of Sciences.
 * Written by Jan Astalos (astalos.ui@savba.sk)
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as published
 * by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston MA 02111-1307, USA.
 *
 * Kernel module for monitoring of system information.
 */

#include <linux/config.h>
#include <linux/module.h>

#ifdef MODVERSIONS
#include <linux/modversions.h>
#endif

#include <asm/uaccess.h>
#include <net/sock.h>
#include <linux/swap.h>
#include <linux/proc_fs.h>
#include <linux/init.h>
#include <linux/kernel_stat.h>

#include "cis.h"

#define LOAD_CONV(a) ((a+(FIXED_1/200)) / (FIXED_1/100))

int read_sysinfo(char *buffer, char **start, off_t offset, int length, int dummy)
{
        int i, len = 0;
        struct sysinfo si;
        struct cis_hostinfo di;

        memset((char *)&di, 0, HOSTINFO_LEN);

        cli();

        di.idle = task[0]->times.tms_utime + task[0]->times.tms_stime;

	di.ctx_swtch = kstat.context_swtch;
	di.swpin  = kstat.pswpin << (PAGE_SHIFT - 10);
	di.swpout = kstat.pswpout << (PAGE_SHIFT - 10);

	for (i = 0; i < 4; i++) {
		di.disk_read[i]  = kstat.dk_drive_rblk[i] >> 1;
		di.disk_write[i] = kstat.dk_drive_wblk[i] >> 1;
	}
	
        di.loads[0] = LOAD_CONV (avenrun[0]);
        di.loads[1] = LOAD_CONV (avenrun[1]);
	di.loads[2] = LOAD_CONV (avenrun[2]);

        di.procnum = nr_tasks-1;
        sti();

	//si_meminfo(&si);
	di.freeram   = nr_free_pages << (PAGE_SHIFT - 10);
        di.sharedram = 0;
	di.bufferram = buffermem >> 10;
        di.cachedram = page_cache_size << (PAGE_SHIFT - 10);

	si_swapinfo(&si);
	di.totalswap = si.totalswap >> 10;
        di.freeswap  = si.freeswap >> 10;

        memcpy (buffer, &di, HOSTINFO_LEN);
        
        *start = buffer + offset;
        len = HOSTINFO_LEN - offset;
        if(len > length)
                len = length;
        if (len < 0)
                len = 0;

        return len;
}

static struct proc_dir_entry proc_root_sysinfo = {
        0,                               /* Inode number      */
        11, "cis_sysinfo",               /* The name of file with length */
        S_IFREG | S_IRUGO,               /* Acess permissions */
        1, 0, 0,                         /* Number of links, owner, group */
        0,                               /* The size - not used */
        NULL,                            /* Operations - use default */
        read_sysinfo,                    /* The read function */
        /* nothing more */
};

int sysmon_init(void)
{
        int err;

        err = proc_register(&proc_root, &proc_root_sysinfo);
        if (err) {
                printk("procmon_init: cannot register sysinfo\n");
                return err;
        }

//        printk (KERN_INFO "System monitoring enabled.\n");

        return 0;
}

int init_module(void)
{
        return sysmon_init ();
}

void cleanup_module(void)
{
        proc_unregister(&proc_root, proc_root_sysinfo.low_ino);

//	printk (KERN_INFO "System monitoring disabled.\n");
}

                