/*
 * Cluster Information Service record file processing library.
 * Copyright (C) 2000 Institute of Informatics, Slovak Academy of Sciences.
 * Written by Jan Astalos (astalos.ui@savba.sk)
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _cis_rec_h
#define _cis_rec_h

#include "cis.h"

struct cis_addr {
	struct in_addr server_addr, node_addr;
};

struct description {
        short offset;
        short length;
        short fragment;
};

extern struct description host_sysinfo_desc[];
extern struct description cis_procinfo_desc[];
extern struct description cis_sockinfo_desc[];

enum {
	CIS_REC_BREAK,
	CIS_REC_TIME,
	CIS_REC_HOST,
	CIS_REC_SYSINFO,
	CIS_REC_PROCESSES,
        CIS_REC_SOCKETS,
	CIS_REC_IFACES,
	CIS_REC_END,
};

#define CIS_RECHDRLEN (sizeof (char) + sizeof (short))

int parse_cmd (char *cmds[], int n, char **c);

/* CIS record files processing */

#define CIS_RECORD_VERSION  4

struct cis_header {
        int version;
	struct timeval time;
	float interval;
	int nhosts;
	struct cis_addr *hosts;
};

#define CIS_HDRLEN (OFFSET(cis_header, hosts))

struct record_info {
        struct timeval time;
        struct cis_addr host;
        char type;
        short length;
        char *data;
        long offset;
        void *host_ptr;
};

int cisHostinfoPrepareChanges(struct cis_hostinfo *oldhi, struct cis_hostinfo *newhi, char **changes);
int cisHostinfoApplyChanges(struct cis_hostinfo *oldhi, char *changes, int chlen, struct cis_hostinfo **newhi);

int cisProclistPrepareChanges(struct cis_procinfo *oldtab, int nold, struct cis_procinfo *newtab, int nnew, char **changes);
int cisProclistApplyChanges(struct cis_procinfo *oldtab, int nold, char *changes, int chlen, struct cis_procinfo **newtab);

int cisSocklistPrepareChanges(struct cis_sockinfo *oldtab, int nold, struct cis_sockinfo *newtab, int nnew, char **changes);
int cisSocklistApplyChanges(struct cis_sockinfo *oldtab, int nold, char *changes, int chlen, struct cis_sockinfo **newtab);

int cisNdevlistPrepareChanges(struct cis_netdevinfo *oldtab, int nold, struct cis_netdevinfo *newtab, int nnew, char **changes);
int cisNdevlistApplyChanges(struct cis_netdevinfo *oldtab, int nold, char *changes, int chlen, struct cis_netdevinfo **newtab);

int cisApplyChanges(int type, void *oldtab, int nold, char *changes, int chlen, void **newtab);

int cisSaveHeader(FILE *file, struct timeval *time, int nhosts, struct cis_addr *hosts, float interval);
int cisReadHeader(FILE *file, struct cis_header **header);

int cisSaveRecord(FILE *file, int type, char *data, int block, int num, int to_save);
int cisReadRecord(FILE *file, struct record_info *rinfo);

int cisReadRecordHeader(FILE *file, struct record_info *rinfo);
int cisReadRecordData(FILE *file, struct record_info *rinfo);

int cisSaveBreak(FILE *file, int length);
int cisSaveTime(FILE *file, struct timeval time);
int cisSaveHostID(FILE *file, struct cis_hostinfo *hi);
int cisSaveHostChanges(FILE *file, struct cis_addr addr);

int cisSaveHostinfo        (FILE *file, struct cis_hostinfo *data);
int cisSaveHostinfoChanges (FILE *file, char *changes, int length);

int cisSaveProclist        (FILE *file, struct cis_procinfo *data, int number);
int cisSaveProclistChanges (FILE *file, char *changes, int length);

int cisSaveSocklist        (FILE *file, struct cis_sockinfo *data, int number);
int cisSaveSocklistChanges (FILE *file, char *changes, int length);

int cisSaveNdevlist        (FILE *file, struct cis_netdevinfo *data, int number);
int cisSaveNdevlistChanges (FILE *file, char *changes, int length);

int cisRecordInfo (FILE *file, struct record_info *rinfo);
int cisParseFile  (FILE *file, struct record_info **rec, void calback(int));

/* end of record processing functions */
#endif
