/*
 * Cluster Information Service - a monitoring system for Linux clusters
 * Copyright (C) 2000 Institute of Informatics, Slovak Academy of Sciences.
 * Written by Jan Astalos (astalos.ui@savba.sk)
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as published
 * by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston MA 02111-1307, USA.
 *
 * Process monitor. Provides CIS server with information about processes.
 */

#include <sys/time.h>
#include <unistd.h>
#include <syslog.h>

#include "cis.h"
#include "mon_common.h"

int main(int argc, char *argv[])
{
	struct timeval timeout;
	fd_set fdset;

	monitor_type = PROCMON;
	
        prepare_init(argc, argv);
	
	procmon.init();

	connect_server();

#ifndef DEBUG
	daemonize();
#endif
	
	procmon.send_init();
	recv_interval();

        procmon.check();
	full_msg = FALSE;
	
	FD_ZERO(&fdset);
	FD_SET(socketfd, &fdset);
	if (procmon.fd > -1)
		FD_SET(procmon.fd, &fdset);

	sectotval(interval_tv, interval);
	timeout = interval_tv;
	
	for (;;) {
		switch (select (FD_SETSIZE, &fdset, NULL, NULL, &timeout)) {
		case 2:
		case 1:
			if (procmon.fd > -1 && FD_ISSET(procmon.fd, &fdset)) {
				procmon.getmsg();
				break;
			}
		case 0:
			if (recv_msg())
				procmon.send_init();
			procmon.check();
			if (!full_msg)
				send_msg();
			if (!full_mode)
				full_msg = FALSE;
			timeout = interval_tv;
			break;
		case -1:
			timeout = interval_tv;
			break;
		default:
			break;
		}
		if (server_ok)
			FD_SET(socketfd, &fdset);
		else
			FD_CLR(socketfd, &fdset);
		if (procmon.fd > -1)
			FD_SET(procmon.fd, &fdset);
	}
}
