/*
 * Cluster Information Service - a monitoring system for Linux clusters
 * Copyright (C) 2000 Institute of Informatics, Slovak Academy of Sciences.
 * Written by Jan Astalos (astalos.ui@savba.sk)
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as published
 * by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston MA 02111-1307, USA.
 *
 * Common functions for all monitors.
 */

#ifndef _MON_COMMON_H
#define _MON_COMMON_H

#include <sys/resource.h>
#include <sys/sysinfo.h>
#include <sys/socket.h>
#include <sys/times.h>
#include <stdio.h>
#include <unistd.h>
#include <signal.h>
#include <locale.h>
#include <syslog.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <linux/types.h>
#include <linux/netlink.h>
#include <dirent.h>
#include <sys/stat.h>

#include <netdb.h>
#include <net/if.h>
#include <sys/utsname.h>
#include <rpc/rpc.h>
#include <rpc/pmap_clnt.h>
#include <rpc/auth.h>

#include "cis_mon.h"

#define CONSISTENT   1
#define TMP_FLAG     (1<<5)

#ifdef DEBUG
#define syslog(tag, fmt, args...)  printf(fmt"\n" , ## args)

extern struct timeval _start_time, _end_time;

#define reset_time()   gettimeofday(&_start_time, 0)
#define show_time(fmt)    { \
	gettimeofday(&_end_time, 0); \
	printf(fmt" %ld\n", (_end_time.tv_sec - _start_time.tv_sec) * 1000000L + _end_time.tv_usec - _start_time.tv_usec); \
	gettimeofday(&_start_time, 0); \
	}

#else

#define reset_time()  {}
#define show_time(fmt)  {}

#endif

#define DEF_INTERVAL  1.

#ifndef MY_PRIORITY
#define MY_PRIORITY             -15
#endif

#define FULL_MODE 1
#define PROC_MODE 2

extern char monitor_type;

extern float interval;
struct timeval interval_tv;

extern int mypid;
extern int full_mode;
extern struct monitor_msg buff;
extern char   *buffptr;
extern int    full_msg;
extern char   tag;

#define bufflen (buffptr - (char *) &buff)

extern int ct_per_sec;
extern int socketfd;

extern int server_ok;

void daemonize (void);
int setfdnoblock (int fd);

void parse_args(int argc, char **argv);
FILE *proc_open(char *name);
void buffer_send(void);
void buffer_flush(void);

#define put(ptr, len) \
	{                                           \
	if ((bufflen + len) > MON_BUFFLEN)   \
	buffer_send();                \
	memcpy(buffptr, ptr, len);           \
	buffptr += len;               \
	}

#define put_object(obj) put(&obj, sizeof(obj))

void send_msg(void);
void init_msg(char msgtag);
int  recv_msg();

void pack_init();
void send_init(char msgtag);
void send_exit(char msgtag);
void prepare_init(int argc, char *argv[]);
void connect_server();
void recv_interval();

#define isroot()   (!myuid)

struct monitor_desc {
	int type;
	int fd;
	void (*init)(void);
	void (*check)(void);
	void (*getmsg)(void);
	void (*send_init)(void);
	void (*send_exit)(void);
};

extern struct monitor_desc sysmon, procmon, sockmon, netmon;

#endif /* _MON_COMMON_H */

