/*
 * Cluster Information Service client library - common XDR routines.
 * Copyright (C) 2000 Institute of Informatics, Slovak Academy of Sciences.
 * Written by Jan Astalos (astalos.ui@savba.sk)
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <rpc/rpc.h>

bool_t xdr_inaddr      (XDR *handle, struct in_addr *a        );
bool_t xdr_tval        (XDR *handle, struct timeval *t        );
bool_t xdr_cisinfo     (XDR *handle, struct cis_info *i       );
bool_t xdr_hostinfo    (XDR *handle, struct cis_hostinfo *i   );
bool_t xdr_process     (XDR *handle, struct cis_procinfo *p   );
bool_t xdr_socket      (XDR *handle, struct cis_sockinfo *s   );
bool_t xdr_socket_desc (XDR *handle, struct cis_sockinfo *s   );
bool_t xdr_u_long_long (XDR *handle, unsigned long long *l    );
bool_t xdr_netdev      (XDR *handle, struct cis_netdevinfo *n );
bool_t xdr_netdev_desc (XDR *handle, struct cis_netdevinfo *n );
