/*
 * Cluster Information Service - a monitoring system for Linux clusters
 * Copyright (C) 2000 Institute of Informatics, Slovak Academy of Sciences.
 * Written by Jan Astalos (astalos.ui@savba.sk)
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as published
 * by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston MA 02111-1307, USA.
 *
 */

#ifndef _CIS_MON_H
#define _CIS_MON_H

#define OFFSET(str, el)  (int) &(((struct str *) 0)->el)

/* Monitor calls */
enum {
        MONITOR_INIT = 0x10,
        MONITOR_EXIT,

	SYSMON_INIT  = 0x20,
        SYSMON_EXIT,
        SYSMON_FULL,
        SYSMON_CHANGES,

	PROCMON_INIT = 0x30,
        PROCMON_EXIT,
        PROCMON_FULL,
        PROCMON_NEW,
        PROCMON_CHANGES,
        PROCMON_CHANGES_ASYNC,

	SOCKMON_INIT = 0x40,
        SOCKMON_EXIT,
        SOCKMON_FULL,
        SOCKMON_NEW,
        SOCKMON_CHANGES,

	NETMON_INIT  = 0x50,
        NETMON_EXIT,
        NETMON_FULL,
        NETMON_NEW,
        NETMON_CHANGES,
};

/* Monitor types (0 is unused) */
enum {
        UNUSED,
        MONITOR,           /* Integrated monitor */
        SYSMON,            /* System monitor */
        PROCMON,           /* Process monitor */
        SOCKMON,           /* Socket monitor */
        NETMON,            /* Network interface monitor (not implemented) */
        NMONITORS,
};

#ifndef CISD_PORT
#define CISD_PORT   500
#endif

#define MON_DATALEN        (2040)

enum {
        OBJ_CREATE = 1,
        OBJ_DESTROY,
        OBJ_CHANGE,
};

/* Netlink device address for kernel modules */
enum {
	NETLINK_PROCMON = 4,
	NETLINK_SOCKMON,
	NETLINK_NETMON,
};

struct monitor_msg {
        unsigned int       time;
        unsigned char      seqnum;
        unsigned char      flags;
        char               data[MON_DATALEN];
};

#define MSG_LAST           1<<1
#define MSG_FIRST          (1<<2)
#define MSG_INIT           (1<<3)

struct monitor_reply {
        int                code;
        char               seqnum;
        float              interval;
};

#define MON_BUFFLEN  (sizeof (struct monitor_msg))



#define monitor_type(a)  ((0x70 & a) >> 4)
#define is_init_msg(a)   (!(0xf & a))


#define usectotval(A,B) { A.tv_sec  = (B) / 1000000L; \
        A.tv_usec = (B) % 1000000L; }

#define tvaltousec(A)   A.tv_sec * 1000000L + A.tv_usec

#define sectotval(A,B) { A.tv_sec  = (int) (B) ; \
        A.tv_usec = (int) (((B) - (int) (B)) * 1000000L); }

#define tvaltosec(A)    (A.tv_sec + (A.tv_usec / 1e6))

#define tvaludiff(A,B)    ((A.tv_sec  - B.tv_sec) * 1000000L + \
        A.tv_usec - B.tv_usec)

#define list_insert(list, item)                        \
        {                                              \
	        if (list)                              \
                        list->prev = item;             \
                item->next = list;                     \
                item->prev = NULL;                     \
                list = item;                           \
        }

#define list_remove(list, item)                        \
        {                                              \
                if (item->prev)                        \
                        item->prev->next = item->next; \
                else                                   \
                        list = item->next;             \
                                                       \
                if (item->next)                        \
                        item->next->prev = item->prev; \
        }

#endif /* _CIS_MON_H */
