/*
 * Cluster Information Service - a monitoring system for Linux clusters
 * Copyright (C) 2000 Institute of Informatics, Slovak Academy of Sciences.
 * Written by Jan Astalos (astalos.ui@savba.sk)
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as published
 * by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston MA 02111-1307, USA.
 */

#ifndef _cis_h
#define _cis_h

#if !defined(__KERNEL__)
#include <netinet/in.h>
#endif

#define CMD_LENGTH         16
#define CIS_HOSTNAMELEN    32
#define CIS_DEVNAMELEN     16
#define MAX_ADDR_NUM       16 /* Should be enough in 'normal' circumstances */
#define MIN_USER_UID       500

enum {
	REL_MINIMAL,
	REL_LOW,
	REL_AVERAGE,
	REL_HIGH,
	REL_MAXIMAL,
	REL_TABLEN,
};

/* Host states */
enum {
        HOST_AVAILABLE     = 0,
        HOST_NOT_AVAILABLE = 100,
        HOST_UNKNOWN       = 101,
};

#define OFFSET(str, el)  (int) &(((struct str *) 0)->el)

struct cis_info
{
	char *name;
};

struct cis_hostinfo
{
        /* Dynamic information */
        unsigned short procnum;
        unsigned short loads[3];
        unsigned long  totalswap;
        unsigned long  freeswap;
        unsigned long  freeram;
        unsigned long  sharedram;
        unsigned long  bufferram;
        unsigned long  cachedram;
        unsigned long  idle;       /* idle time from host startup in jiffies */
                                   /* 1 jiffie = 1/ct_per_sec [s] */

	unsigned long  ctx_swtch;
	
	unsigned short CPU_available;

        /* Static information */
        char           status;
	unsigned char  reliability;
        unsigned short ct_per_sec; /* clock ticks per second */
	struct in_addr addr;
	struct in_addr caddr;
	char           name[CIS_HOSTNAMELEN];
	unsigned long  totalram;
	float          performance;
};

#define HOSTINFO_LEN (OFFSET(cis_hostinfo, CPU_available))

struct cis_procinfo
{
        unsigned int   pid;
	unsigned long  start_time;            /* start time (GMT)          [s] */
        unsigned int   uid;
        unsigned int   ppid;

        char           cmd[CMD_LENGTH];

        unsigned long  rss;
        unsigned long  vm;

        long           priority;
        
        unsigned long  stime;                 /* time spent in system mode [s] */
        unsigned long  utime;                 /* time spent in user mode   [s] */

	short          pCPU;                  /* real CPU time consumption */
                                              /* 9999 -> 99.99% */

	unsigned long  minflt;
        unsigned long  majflt;

	unsigned long  rd_bytes;
        unsigned long  wr_bytes;
        
        void *priv;
};
#define PROCINFO_LEN  (OFFSET(cis_procinfo, priv))

struct cis_sockinfo
{
        struct in_addr saddr;
        struct in_addr daddr;

        unsigned short sport;
        unsigned short dport;

        short          type;

        unsigned short uid;
        unsigned int   pid;
        
        unsigned long sent;
        unsigned long rcvd;

        void *priv;
};

#define SOCKINFO_LEN     (OFFSET(cis_sockinfo, priv))
#define SOCKINFO_HDRLEN  (OFFSET(cis_sockinfo, uid))

struct cis_netdevinfo
{
        char name[CIS_DEVNAMELEN];

        unsigned char id;
        unsigned char status;

        unsigned long rx_bytes;
        unsigned long tx_bytes;

        unsigned long collisions;

	void *priv;
};

#define NETDEVINFO_LEN  (OFFSET(cis_netdevinfo, priv))

#endif
