/*
 * Cluster Information Service - a monitoring system for Linux clusters
 * Copyright (C) 2000 Institute of Informatics, Slovak Academy of Sciences.
 * Written by Jan Astalos (astalos.ui@savba.sk)
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as published
 * by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston MA 02111-1307, USA.
 */

struct host_info
{
        int naddr;
        struct in_addr addrlist[MAX_ADDR_NUM];

	char *name;
	
        struct monitor_info *monitor[CIS_MONITOR_TYPES];

        int    defprio;
	struct cis_uname uname;
        struct cis_hostinfo hostinfo;

	float  *performance;
        
        unsigned long idle_at;
	
	int proc_ht_length;
	int proc_ht_capacity;
	int proc_ht_use;
        struct cis_procinfo **proc_ht;
        struct cis_procinfo *proclist;
        long slsum;

	int sock_ht_length;
        int sock_ht_capacity;
	int sock_ht_use;
        struct cis_sockinfo **sock_ht;
        struct cis_sockinfo *socklist;

        struct cis_netdevinfo *netdevlist;

	struct host_info *next;

};

struct clnt_req {

        struct in_addr      addr;
        struct host_info    *host;
        struct monitor_info *monitor;
        unsigned long       time;

        unsigned short uid;
        float interval;

        int code;
        int nhosts;
	struct in_addr *addrtab;

	char *perf_type;
};

#ifndef PROC_HISTORY_LENGTH
#define PROC_HISTORY_LENGTH     3
#endif

#ifndef NET_HISTORY_LENGTH
#define NET_HISTORY_LENGTH     60
#endif

struct history {
        unsigned long time;
        unsigned long change;
};

struct monitor_info
{
        unsigned short      port;

	unsigned short      ct_per_sec;

	unsigned long       clk_interval;
        
        struct timeval      start_tv;  /* refernece time in sec */
        unsigned long       start_clk; /* reference time in clock tics */

        unsigned long       local_time;
	struct timeval      time_tv;
	
        unsigned char       seqnum;
        unsigned char       flags;
};


struct process_private_info {

        struct cis_procinfo *prev, *next;
        struct cis_procinfo *children;

        struct history history[PROC_HISTORY_LENGTH];
        struct history *last;

        unsigned long init_interval;
        
        unsigned long interval;
        unsigned long CPU_used;

        unsigned long GMT_start_time;
        unsigned long utime_sec, stime_sec;
};

struct net_history {

        struct history history[NET_HISTORY_LENGTH];
        struct history *last;

        unsigned long interval;
        unsigned long bytes;
};

struct socket_private_info {
        struct net_history sent_history;
        struct net_history rcvd_history;

        unsigned long send_rate;
        unsigned long recv_rate;
};

struct netdev_private_info {

        struct net_history rxbytes_history;
        struct net_history txbytes_history;
        struct net_history collisions_history;

        unsigned long rxbytes_rate;
        unsigned long txbytes_rate;
        unsigned long collisions_rate;
};

#define tvaldiff(a, b) (a.tv_sec - b.tv_sec + ((a.tv_usec - b.tv_usec) / 1e6))

#define monitor_time(monitor) \
        (monitor->local_time + (unsigned long) ((tvaldiff(current_tv, monitor->time_tv) * \
	monitor->ct_per_sec)))

